//
//  Retrieving_the_List_of_CalendarsAppDelegate.m
//  Retrieving the List of Calendars
//
//  Created by Vandad Nahavandipoor on 24/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Retrieving_the_List_of_CalendarsAppDelegate.h"

@implementation Retrieving_the_List_of_CalendarsAppDelegate

@synthesize window = _window;

- (BOOL)            application:(UIApplication *)application 
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  EKEventStore *eventStore = [[EKEventStore alloc] init];
  
  /* To są rodzaje kalendarzy dostępne w urządzeniu iOS. Zwróć uwagę, że
   właściwość "type" obiektu typu EKCalendar jest typu EKCalendarType.
   Wartości w tablicy "CalendarTypes" odzwierciedlają dokładnie
   te same wartości znajdujące się w typie wyliczeniowym EKCalendarType,
   ale tutaj są podane w postaci wartości NSString. */
  NSArray *calendarTypes = [[NSArray alloc] initWithObjects:
                            @"Local",
                            @"CalDAV",
                            @"Exchange",
                            @"Subscription",
                            @"Birthday",
                            nil];
  
  /* Iteracja przez dostępne kalendarze, po kolei. */
  NSUInteger counter = 1;
  for (EKCalendar *thisCalendar in eventStore.calendars){
    
    /* Nazwa kalendarza. */
    NSLog(@"Nazwa kalendarza %lu = %@",
          (unsigned long)counter, thisCalendar.title);
    
    /* Typ kalendarza. */
    NSLog(@"Typ kalendarza %lu = %@",
          (unsigned long)counter,
          [calendarTypes objectAtIndex:thisCalendar.type]);
    
    /* Kolor przypisany kalendarzowi. */
    NSLog(@"Kolor kalendarza %lu = %@",
          (unsigned long)counter,
          [UIColor colorWithCGColor:thisCalendar.CGColor]);
    
    /* Określenie, czy kalendarz może być modyfikowany, czy nie może. */
    if ([thisCalendar allowsContentModifications]){
      NSLog(@"Kalendarz %lu może być modyfikowany.",
            (unsigned long)counter);
    } else {
      NSLog(@"Kalendarz %lu nie może być modyfikowany.",
            (unsigned long)counter);
    }
    
    counter++;
  }
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
